
#ifndef _BC3602_H_
#define _BC3602_H_

#include	"BC3602reg.h"
#include	"ht32f520xx_01.h" 

#define  _SPI_ARCHITECTURE_ (1)
// Interface Configuration
//    MCU & RFIC SPI Architecture
//       <0=> 3-3 Wire
//       <1=> 4-4 Wire
//       <i> 0:MCU 3-Wire & RFIC 3-Wire
//       <i> 2:MCU 4-Wire & RFIC 4-Wire
#define  _SPI_PULL_HIGH_ (0xB9)
//#define  _SPI_PULL_HIGH_ (0x82)
#define _SPI_SPEED_  (5000000UL)

#define  _GPIO_CURRENT_ (0x40)
//   GPIO Current Configuration
//      GPIO Current
//       	<0=> 0.5mA
//       	<1=>   1mA
//       	<2=>   5mA
//       	<3=>  10mA

#define _SDO_LINE_  (0)
//    BC3602 SDO for GPIO1/2/3/4
//       <0=> GPIO1
//       <1=> GPIO2
//       <2=> GPIO3
//       <3=> GPIO4

#if (_SPI_ARCHITECTURE_ == 0)
	#define	_GIO1_FUNCTION_	INPUT_MODE
#else
	#define	_GIO1_FUNCTION_	SPI_SDO_FUN
#endif
#define	_GIO2_FUNCTION_	INT_REQUEST
#define	_GIO3_FUNCTION_	EPA_CTLO    // INPUT_MODE EPA_CTLO
#define	_GIO4_FUNCTION_	ELNA_CTLO     //ELNA_CTLO

#define  RF_SPI         HT_SPI1
#define  RF_SPI_CFGR    HT_AFIO->GPACFGR[0]										
#define  RF_SPI_PORT    HT_GPIOA														
#define  _RF_CSN_       3																	
#define  _RF_SCK_       0																	
#define  _RF_MOSI_      1																	
#define  _RF_MISO_      2																	
#define  RF_CSN         (1UL << _RF_CSN_)
#define  RF_SCK         (1UL << _RF_SCK_) 
#define  RF_MOSI        (1UL << _RF_MOSI_)
#define  RF_MISO        (1UL << _RF_MISO_)
#define  RF_SPI_CFGR_MK ((2UL << (_RF_CSN_*4))|(2UL << (_RF_SCK_*4))|(2UL << (_RF_MOSI_*4))|(2UL << (_RF_MISO_*4)))

#define	RF_CSN_LOW		(RF_SPI_PORT->DOUTR &= ~RF_CSN)
#define	RF_CSN_HIGH		(RF_SPI_PORT->DOUTR |= RF_CSN)
#define	RF_SCK_LOW		(RF_SPI_PORT->DOUTR &= ~RF_SCK)
#define	RF_SCK_HIGH		(RF_SPI_PORT->DOUTR |= RF_SCK)
#define	RF_SPI_ACTIVE	RF_SPI->CR0 |= SPI_SEL_ACTIVE
#define	RF_SPI_INACTIVE RF_SPI->CR0 &= SPI_SEL_INACTIVE

u32	extern tx_packet_time,rx_packet_time;
u8 extern TxPayloadData[64];
u8 extern RxPayloadData[64];
enum 
{
   GIO1 = 0,
   GIO2,
   GIO3,
   GIO4
};

#define  BC3602_SoftwareReset()           		BC3602_StrobeCommand(SOFT_RESET_CMD)
#define  BC3602_RegisterBank(regbk)         	BC3602_StrobeCommand(REGS_BANK_CMD+regbk)
#define  BC3602_DeepSleepMode()								BC3602_StrobeCommand(DEEP_SLEEP_CMD)
#define  BC3602_IdleMode()                   	BC3602_StrobeCommand(IDLE_MODE_CMD)
#define  BC3602_LightSleepMode()            	BC3602_StrobeCommand(LIGHT_SLEEP_CMD)
#define  BC3602_StandbyMode()                	BC3602_StrobeCommand(STANDBY_MODE_CMD)
#define  BC3602_TransmitterMode()            	BC3602_StrobeCommand(TX_MODE_CMD)
#define  BC3602_ReceiveMode()                	BC3602_StrobeCommand(RX_MODE_CMD)
#define  BC3602_ResetTxFifoPointer()					BC3602_StrobeCommand(REST_TX_POS_CMD)
#define  BC3602_ResetRxFifoPointer()					BC3602_StrobeCommand(REST_RX_POS_CMD)
#define  BC3602_SetTxPayloadWidth(wd)					BC3602_WriteRegister(TX_DATA_LENG_REGS,wd)
#define  BC3602_SetRxPayloadWidth(wd)					BC3602_WriteRegister(RX_DATA_LENG_REGS,wd)
#define  BC3602_GetRxPayloadWidth()						BC3602_ReadRegister(RX_DATA_LENG_REGS)
#define  BC3602_SetTxPayloadSaddr(ad)					BC3602_WriteRegister(TX_FIFO_SA_REGS,ad)
#define  BC3602_GetIrqState()									BC3602_ReadRegister(IRQ_STATUS_REGS)
#define  BC3602_ClearIrqFlag(sts)							BC3602_WriteRegister(IRQ_STATUS_REGS,sts)
#define	 BC3602_GetModeState()								BC3602_ReadRegister(MODE_STATUS_REGS)

#define  BC3602_ReadRxPayload(pbuf,len)     	BC3602_ReadMultibyteRegister(READ_FIFO_CMD,pbuf,len)
#define  BC3602_WriteTxPayload(pbuf,len)    	BC3602_WriteMultibyteRegister(WRITE_FIFO_CMD,pbuf,len)
#define  BC3602_WriteTxPayloadRing(pbuf,len,start,tlen)    BC3602_WriteMultibyteRingRegister(WRITE_FIFO_CMD,pbuf,len,start,tlen)
#define  BC3602_ReadSyncWord(pbuf,len)      	BC3602_ReadMultibyteRegister(READ_SYNCWORD_CMD,pbuf,len)
#define  BC3602_WriteSyncWord(pbuf,len)     	BC3602_WriteMultibyteRegister(WRITE_SYNCWORD_CMD,pbuf,len)


void  BC3602_StrobeCommand(u8 cmd);
u8    BC3602_ReadRegister(u8 regs);
void  BC3602_WriteRegister(u8 regs,u8 data);
void  BC3602_ReadMultibyteRegister(u8 cmd,u8 *pbuf,u16 length);
void  BC3602_WriteMultibyteRegister(u8 cmd,u8 *pbuf,u16 length);
void 	BC3602_WriteMultibyteRingRegister(u8 cmd,u8 *pbuf,u16 length,u8 buf_st,u8 buf_l);


void  BC3602_InterfaceConfigure(void);
void  BC3602_Initial(void);
void  BC3602_LircCalibartion(void);
void  BC3602_VcoCalibartion(void);
void  BC3602_CrystalReady(void);
void  BC3602_GioConfigure(u8 gio,u8 fun);
void  BC3602_IrqConfigure(u8 irq_en);
void  BC3602_AgcConfigure(u8 en);
void  BC3602_CrystalConfigure(void);
void  BC3602_PreambleConfigure(u16 tx_preamble,u8 rx_preamble);
void  BC3602_SyncwordConfigure(u8 length, int64_t id);
void  BC3602_HeaderConfigure(u8 PLLEN_EN, u8 PLHAC_EN, u8 PLHLEN, u8 PLH_EN);
void  BC3602_ManchesterConfigure(u8 man_EN);
void  BC3602_FecConfigure(u8 fec_EN);
void  BC3602_Crc_Configure(u8 crc_EN, u8 crcfmt);
void  BC3602_TrailerConfigure(u8 tra_EN);
void  BC3602_WhiteningConfigure(u8 wht_EN, u8 whtfmt, u8 wht_seed);
void  BC3602_FrequencyConfigure(float frequ);
void  BC3602_PowerConfigure(u8 pwr);
void  BC3602_DataRateConfigure(u8 dr);
void  BC3602_ExtendMarginConfigure(u8 mar_EN, u8 length);
void  BC3602_AnalogRegisterConfigure(void);

u32 	BC3602_GetDatarate(u8 dr);
void	BC3602_EnableDirTx(void);
void	BC3602_EnableDirRx(void);
void 	BC3602_DisableDir(void); 

bool is_same_data(u8 *saddr, u8 *taddr, u32 len);
bool is_same_data_ring(u8 *addr1,u8 *addr2,u32 len,u8 str,u8 tlen);

void goto_default_mode(void);

void parameter_initialization(void);
u32 cal_packet_time(u8 sel);

//Layer 2
void  BC3602_SetAutoCycleMode(u8 md,bool en);
u8		BC3602_SetCycleClockUnit(u32 tm);
u16		BC3602_CalCycleCounter(u32 tm);
void	BC3602_EnableATRCTM(bool flag);
void  BC3602_SetAutoCycleTimer(u32 tm);
void  BC3602_TuneAutoCycleCounter(int16_t cnt);
void  BC3602_SetATRCT_Timer(u32 tm);
void  BC3602_SetATRCT_Counter(u16 atrct);
u32 	BC3602_GetATRCT_Counter(void);
void  BC3602_SetAutoRxActivePeriod(u32 tm);
void  BC3602_SetAutoRxExtendPeriod(u32 tm);
u16   BC3602_GetAutoCycleCounter(void);
void 	BC3602_EnableARK(bool en);
bool 	BC3602_SetARKRXAP_Timer(u32 tm);
u8		BC3602_GetAutoRetryNumber(void);
void  BC3602_SetAutoRetryNumber(u8 counter);
void	BC3602_IncPID(void);
u8 		BC3602_ReadReceiveRSSI(void);
u8 		BC3602_ReadEnvironmentRSSI(void);

#endif   /* _BC3602_H_ */
